package com.schbrain.archetype.initializer.response;

import cn.hutool.core.io.FileUtil;
import lombok.Data;

import java.io.File;
import java.util.Collections;
import java.util.List;

/**
 * @author liaozan
 * @since 2022/3/20
 */
@Data
public class PreviewFileTree {

    private String fileName;

    private String fileContent;

    private Boolean isFile;

    private List<PreviewFileTree> children;

    public PreviewFileTree(File file) {
        this(file, Collections.emptyList());
    }

    public PreviewFileTree(File file, List<PreviewFileTree> children) {
        this.isFile = file.isFile();
        this.fileName = file.getName();
        this.children = children;
        if (this.isFile) {
            this.fileContent = FileUtil.readUtf8String(file);
        }
    }

}