package com.schbrain.archetype.initializer.controller;

import com.schbrain.archetype.initializer.config.properties.ProjectGroupProperties;
import com.schbrain.archetype.initializer.param.ArchetypeGenerateParam;
import com.schbrain.archetype.initializer.response.PreviewFileTree;
import com.schbrain.archetype.initializer.service.ArchetypeService;
import com.schbrain.common.web.result.ResponseDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;

/**
 * @author liaozan
 * @since 2022/3/20
 */
@RestController
@EnableConfigurationProperties(ProjectGroupProperties.class)
public class ArchetypeController {

    @Autowired
    private ArchetypeService archetypeService;
    @Autowired
    private ProjectGroupProperties projectGroupProperties;

    /**
     * 获取允许的 group 列表
     */
    @GetMapping("/archetype/allowed_groups")
    public ResponseDTO<List<String>> getAllowedGroupList() {
        return ResponseDTO.success(projectGroupProperties.getAllowList());
    }

    /**
     * 生成项目
     */
    @PostMapping("/archetype/generate")
    public ResponseDTO<String> generateArchetype(@RequestBody @Validated ArchetypeGenerateParam param) throws FileNotFoundException {
        return ResponseDTO.success(archetypeService.generate(param));
    }

    /**
     * 预览项目
     */
    @GetMapping("/archetype/preview/{id}")
    public ResponseDTO<List<PreviewFileTree>> previewArchetype(@PathVariable String id) throws FileNotFoundException {
        return ResponseDTO.success(archetypeService.preview(id));
    }

    /**
     * 下载项目
     */
    @GetMapping("/archetype/download/{id}")
    public void downloadArchetype(@PathVariable String id) throws IOException {
        archetypeService.download(id);
    }

}
