import axios from 'axios';
import {hideLoading, showLoading} from './loading'

const envDict = {
    'development': 'http://localhost:8080',
    'production': 'https://start.develop.schbrain.com'
}

axios.defaults.baseURL = envDict[process.env.NODE_ENV]
axios.defaults.timeout = 10000

const service = axios.create()

service.interceptors.request.use(config => {
    showLoading()
    return config
})

service.interceptors.response.use(response => {
    hideLoading()
    if (response.headers['content-type'] === 'application/json') {
        if (response.data.code !== 0) {
            return Promise.reject(response);
        }
    }
    return response
}, error => {
    hideLoading()
    return Promise.reject(error)
})

export default service