import type {AxiosRequestConfig, AxiosResponse} from "axios";
import axios from "axios";
import {message} from "ant-design-vue";
import {ref} from 'vue'

export const isLoading = ref(false)

// @ts-ignore
axios.defaults.baseURL = import.meta.env.VITE_APP_BASE_URL
axios.interceptors.request.use((config: AxiosRequestConfig) => {
    isLoading.value = true
    return config
})

axios.interceptors.response.use((config: AxiosResponse) => {
    isLoading.value = false
    const {data} = config
    if (config.headers['content-type'] === 'application/json') {
        switch (data.code) {
            case 0:
                return Promise.resolve(data)
            default:
                message.error(data.message).then()
                return Promise.reject(data)
        }
    } else {
        return Promise.resolve(config)
    }
})

export default axios