package com.schbrain.archetype.initializer.param;

import lombok.Data;
import org.springframework.util.StringUtils;

import javax.validation.constraints.NotBlank;

/**
 * @author liaozan
 * @since 2022/3/20
 */
@Data
public class ArchetypeGenerateParam {

    private static final String DELIMITER = "-";

    /**
     * groupId
     */
    @NotBlank
    private String groupId;
    /**
     * artifactId
     */
    @NotBlank
    private String artifactId;
    /**
     * version
     */
    private String version = "1.0.0-SNAPSHOT";
    /**
     * packageName
     */
    private String packageName;
    /**
     * 子模块前缀
     */
    private String subModuleNamePrefix;

    public String getSubModuleNamePrefix() {
        if (!StringUtils.hasText(this.subModuleNamePrefix)) {
            if (this.artifactId.contains(DELIMITER)) {
                this.subModuleNamePrefix = this.artifactId.split(DELIMITER)[1];
            } else {
                this.subModuleNamePrefix = this.artifactId;
            }
        }
        return this.subModuleNamePrefix;
    }

    public String getPackageName() {
        if (!StringUtils.hasText(this.packageName)) {
            this.packageName = String.format("%s.%s", this.groupId, this.getSubModuleNamePrefix());
        }
        return this.packageName;
    }

}