package com.schbrain.archetype.initializer.controller;

import com.schbrain.archetype.initializer.param.ArchetypeGenerateParam;
import com.schbrain.archetype.initializer.response.PreviewFileTree;
import com.schbrain.archetype.initializer.service.ArchetypeService;
import com.schbrain.common.support.result.ResponseDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;

/**
 * @author liaozan
 * @since 2022/3/20
 */
@RestController
public class ArchetypeController {

    @Autowired
    private ArchetypeService archetypeService;

    @GetMapping("/archetype/update")
    public ResponseDTO<Boolean> updateArchetype() {
        return ResponseDTO.success(archetypeService.update());
    }

    @PostMapping("/archetype/generate")
    public ResponseDTO<String> generateArchetype(@RequestBody @Validated ArchetypeGenerateParam param) {
        return ResponseDTO.success(archetypeService.generate(param));
    }

    @GetMapping("/archetype/preview/{id}")
    public ResponseDTO<List<PreviewFileTree>> previewArchetype(@PathVariable String id) throws FileNotFoundException {
        return ResponseDTO.success(archetypeService.preview(id));
    }

    @GetMapping("/archetype/download/{id}")
    public void downloadArchetype(@PathVariable String id) throws IOException {
        archetypeService.download(id);
    }

}