package com.schbrain.archetype.initializer.service;

import cn.hutool.core.lang.tree.Tree;
import cn.hutool.core.lang.tree.TreeNode;
import cn.hutool.core.lang.tree.TreeUtil;
import com.schbrain.common.exception.BaseException;
import lombok.extern.slf4j.Slf4j;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GroupApi;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author liaozan
 * @since 2022/4/28
 */
@Slf4j
@Component
public class GitlabService {

    @Autowired
    private GitLabApi gitLabApi;

    public List<Tree<Long>> fetchGroups() {
        try {
            GroupApi groupApi = gitLabApi.getGroupApi();
            List<TreeNode<Long>> treeNodes = groupApi.getGroupsStream()
                    .map(group -> {
                        TreeNode<Long> treeNode = new TreeNode<>();
                        treeNode.setId(group.getId());
                        treeNode.setName(group.getName());
                        treeNode.setParentId(group.getParentId());
                        return treeNode;
                    }).collect(Collectors.toList());
            return TreeUtil.build(treeNodes, null);
        } catch (Exception e) {
            throw new BaseException("Failed to fetch Gitlab groups", e);
        }
    }

}
