package com.schbrain.archetype.initializer.controller;

import cn.hutool.core.lang.tree.Tree;
import com.schbrain.archetype.initializer.service.GitlabService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author liaozan
 * @since 2022/4/28
 */
@RestController
public class GitlabController {

    @Autowired
    private GitlabService gitlabService;

    /**
     * 获取 gitlab 群组
     */
    @GetMapping("/gitlab/groups")
    public List<Tree<Long>> groupList() {
        return gitlabService.fetchGroups();
    }

}
