package com.schbrain.archetype.initializer.config;

import com.schbrain.archetype.initializer.config.properties.GitProperties;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.gitlab4j.api.GitLabApi;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author liaozan
 * @since 2022/4/28
 */
@Configuration(proxyBeanMethods = false)
@EnableConfigurationProperties(GitProperties.class)
public class GitConfiguration {

    @Autowired
    private GitProperties gitProperties;

    @Bean
    public GitLabApi gitLabApi() {
        return new GitLabApi(gitProperties.getServerUrl(), gitProperties.getPersonalAccessToken());
    }

    @Bean
    public UsernamePasswordCredentialsProvider credentialsProvider() {
        return new UsernamePasswordCredentialsProvider("PRIVATE-TOKEN", gitProperties.getPersonalAccessToken());
    }

}