import axios from 'axios';
import {hideLoading, showLoading} from './loading'

const envDict = {
    'development': 'http://localhost:8080',
    'production': 'http://192.168.36.27:8080'
}

axios.defaults.baseURL = envDict[process.env.NODE_ENV]
axios.defaults.timeout = 10000

const service = axios.create()

service.interceptors.request.use(config => {
    showLoading()
    return config
})

service.interceptors.response.use(response => {
    hideLoading()
    if (response.data.type === 'application/json') {
        if (response.data.code !== 200) {
            return Promise.reject(response);
        }
    }
    return response
}, error => {
    hideLoading()
})

export default service