package com.schbrain.archetype.initializer.runner;

import cn.hutool.core.io.FileUtil;
import cn.hutool.system.SystemUtil;
import com.schbrain.archetype.initializer.maven.MavenUtils;
import lombok.extern.slf4j.Slf4j;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.TagOpt;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

import java.io.File;

/**
 * @author liaozan
 * @since 2022/3/20
 */
@Slf4j
@Component
public class ArchetypePreparer implements ApplicationRunner {

    private static final String ARCHETYPE_REPO_URL = "http://gitlab.schbrain.com/gitlab/tools/schbrain-archetype.git";

    @Override
    public void run(ApplicationArguments args) throws GitAPIException {
        File archetypeTemplateDirectory = createArchetypeDirectory();
        checkoutArchetype(archetypeTemplateDirectory);
        MavenUtils.install(archetypeTemplateDirectory.getAbsolutePath());
    }

    private File createArchetypeDirectory() {
        String tempDir = SystemUtil.getUserInfo().getTempDir();
        File archetypeTemplateDirectory = new File(tempDir, "archetype");
        FileUtil.del(archetypeTemplateDirectory);
        return archetypeTemplateDirectory;
    }

    private void checkoutArchetype(File archetypeTemplateDirectory) throws GitAPIException {
        Git git = Git.cloneRepository()
                .setTagOption(TagOpt.FETCH_TAGS)
                .setNoCheckout(false)
                .setDirectory(archetypeTemplateDirectory)
                .setCloneSubmodules(false)
                .setURI(ARCHETYPE_REPO_URL)
                .setRemote("upstream")
                .call();
        CheckoutCommand checkoutCommand = git.checkout().setName("archetype").setCreateBranch(true);
        Ref ref = checkoutCommand.call();
        log.info("Success checkout archetype branch: {} of {}", ref.getName(), ARCHETYPE_REPO_URL);
    }

}