package com.schbrain.archetype.initializer.listener;

import com.schbrain.archetype.initializer.maven.MavenUtils;
import com.schbrain.archetype.initializer.param.ArchetypeGenerateParam;
import lombok.SneakyThrows;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

/**
 * @author liaozan
 * @since 2022/3/20
 */
public class ProjectWarmUpListener implements ApplicationListener<ApplicationStartedEvent> {

    private final Executor executor = Executors.newSingleThreadExecutor();

    @SneakyThrows
    @Override
    public void onApplicationEvent(ApplicationStartedEvent event) {
        executor.execute(() -> {
            ArchetypeGenerateParam mockParam = new ArchetypeGenerateParam();
            mockParam.setGroupId("com.schbrain");
            mockParam.setArtifactId("schbrain-init");
            MavenUtils.generate(mockParam);
        });
    }

}