package com.schbrain.archetype.initializer.controller;

import com.schbrain.archetype.initializer.maven.MavenUtils;
import com.schbrain.archetype.initializer.param.ArchetypeGenerateParam;
import com.schbrain.common.util.ServletUtils;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.StreamUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

/**
 * @author liaozan
 * @since 2022/3/20
 */
@RestController
public class InitializerController {

    @PostMapping("/archetype/generate")
    public void generateArchetype(@RequestBody @Validated ArchetypeGenerateParam param) throws IOException {
        File generatedProject = MavenUtils.generate(param);

        FileInputStream inputStream = new FileInputStream(generatedProject);

        HttpServletResponse response = ServletUtils.getResponse();
        response.addHeader(HttpHeaders.CONTENT_DISPOSITION, contentDisposition(generatedProject));
        response.setContentType(MediaType.APPLICATION_OCTET_STREAM_VALUE);

        StreamUtils.copy(inputStream, response.getOutputStream());
    }

    private String contentDisposition(File file) {
        return ContentDisposition
                .attachment()
                .filename(file.getName())
                .build()
                .toString();
    }

}