package com.schbrain.initializer.web.controller;

import cn.hutool.core.util.RandomUtil;
import com.schbrain.common.util.BeanCopyUtils;
import com.schbrain.common.util.JacksonUtils;
import com.schbrain.common.util.support.lock.RedisLockUtils;
import com.schbrain.framework.autoconfigure.mybatis.base.BaseEntity;
import com.schbrain.framework.autoconfigure.mybatis.base.BaseService;
import com.schbrain.initializer.dao.entity.Entity;
import com.schbrain.initializer.dao.entity.EntityWithLogicDelete;
import com.schbrain.initializer.service.EntityService;
import com.schbrain.initializer.service.EntityWithLogicDeleteService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.tuple.Triple;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDate;
import java.util.*;

/**
 * @author liaozan
 * @since 2022/8/9
 */
@Slf4j
@SuppressWarnings("DuplicatedCode")
@RestController
public class EntityController {

    @Autowired
    private EntityService entityService;
    @Autowired
    private EntityWithLogicDeleteService entityWithLogicDeleteService;

    @GetMapping("/copy")
    public void copy() {
        Entity entity = new Entity();
        entity.setId(1L);
        Entity copied = BeanCopyUtils.copy(entity, Entity.class);
        System.out.println(copied);
    }

    @GetMapping("/time")
    public Triple<Date, LocalDate, Entity> dateTime(@RequestParam Date date,
                                                    @RequestParam LocalDate dateTime,
                                                    @RequestBody Entity entity) {
        log.info("date: {}", date);
        log.info("dateTime: {}", dateTime);
        return Triple.of(date, dateTime, entity);
    }

    @GetMapping("/lock")
    public void lock() {
        RedisLockUtils.executeWithLock("lock", () -> System.out.println("lock"));
    }

    @GetMapping("/bizId")
    public void bizId() {
        String name = entityService.getById(106L, Entity::getName);
        System.out.println(JacksonUtils.toPrettyJsonString(name));

        Entity entity = entityService.getByBizId("8352707733");
        System.out.println(JacksonUtils.toPrettyJsonString(entity));

        Integer age = entityService.getByBizId("8352707733", Entity::getAge);
        System.out.println(age);

        Long id = entityService.getByBizId("8352707733", Entity::getId);
        System.out.println(id);

        List<Entity> entities = entityService.listByBizIds(List.of("8352707733", "1119254675595816960"));
        System.out.println(JacksonUtils.toPrettyJsonString(entities));

        Map<String, Entity> entityMap = entityService.getMapByBizIds(List.of("8352707733", "1119254675595816960"));
        System.out.println(JacksonUtils.toPrettyJsonString(entityMap));

        List<String> names = entityService.listByBizIds(List.of("8352707733", "1119254675595816960"), Entity::getName);
        System.out.println(JacksonUtils.toPrettyJsonString(names));

        List<String> nameList = entityService.listByIds(List.of(37L, 106L, 107L), Entity::getName);
        System.out.println(JacksonUtils.toPrettyJsonString(nameList));
    }

    @GetMapping("/entity")
    public void entity() {
        Entity entity = new Entity();
        entity.setName(RandomUtil.randomNumbers(10));

        entity.setId(null);
        entityService.save(entity);

        entity = entityService.getById(entity.getId());

        entity.setName(null);
        entityService.updateByIdWithNull(entity);

        entityService.lambdaUpdate().eq(BaseEntity::getId, entity.getId()).remove();

        entity.setName(RandomUtil.randomNumbers(10));
        doOperation(entity, entityService);
    }

    @GetMapping("/entity_with_logic_delete")
    public void entityWithLogicDelete() {
        EntityWithLogicDelete entity = new EntityWithLogicDelete();
        entity.setName(RandomUtil.randomNumbers(10));

        entity.setId(null);
        entityWithLogicDeleteService.save(entity);

        entity = entityWithLogicDeleteService.getById(entity.getId());

        entity.setName(null);
        entityWithLogicDeleteService.updateByIdWithNull(entity);

        entityWithLogicDeleteService.lambdaUpdate().eq(BaseEntity::getId, entity.getId()).remove();

        entity.setName(RandomUtil.randomNumbers(10));
        doOperation(entity, entityWithLogicDeleteService);
    }

    private <T extends BaseEntity> void doOperation(T entity, BaseService<T> service) {
        entity.setId(null);
        service.save(entity);
        service.removeById(entity.getId());

        entity.setId(null);
        service.save(entity);
        service.removeBatchByIds(List.of(entity.getId()));

        entity.setId(null);
        service.save(entity);
        service.removeByMap(Map.of("id", entity.getId()));
    }

}
