package com.schbrain.web;

import com.alibaba.otter.canal.protocol.CanalEntry;
import com.schbrain.canal.client.annotation.TableFilter;
import com.schbrain.canal.client.event.CanalEvent;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author zhuyf
 * @date 2022/6/16
 */
@Service("myCanalEvent")
@TableFilter(table = "uc_user_info",schame = "kp_user")  //暂时未实现
public class MyCanalEvent implements CanalEvent {

    @Override
    public void onEvent(CanalEntry.Header header,CanalEntry.EventType eventType, CanalEntry.RowData rowData) {
        System.out.println("======"+header.getSchemaName()+":"+header.getTableName()+":"+eventType.name());
        //如果是删除语句
        if (eventType == CanalEntry.EventType.DELETE) {
            printColumn(rowData.getBeforeColumnsList());
            //如果是新增语句
        } else if (eventType == CanalEntry.EventType.INSERT) {
            printColumn(rowData.getAfterColumnsList());
            //如果是更新的语句
        } else {
            //变更前的数据
            System.out.println("------->; before");
            printColumn(rowData.getBeforeColumnsList());
            //变更后的数据
            System.out.println("------->; after");
            printColumn(rowData.getAfterColumnsList());
        }

    }

    private static void printColumn(List<CanalEntry.Column> columns) {
        for (CanalEntry.Column column : columns) {
            System.out.println(column.getName() + " : " + column.getValue() + "    update=" + column.getUpdated());
        }
    }
}
