package com.schbrain.canal.client.event;

import com.alibaba.otter.canal.protocol.CanalEntry;

public interface DefCanalEvent extends CanalEvent{

    @Override
    default void onEvent(CanalEntry.Header header,CanalEntry.EventType eventType, CanalEntry.RowData rowData){
        switch (eventType) {
            case INSERT:
                onInsert(header,rowData);
                break;
            case UPDATE:
                onUpdate(header,rowData);
                break;
            case DELETE:
                onDelete(header,rowData);
                break;
            default:
                break;
        }
    }

    /**
     * onInsert
     * @param rowData
     */
    void onInsert(CanalEntry.Header header,CanalEntry.RowData rowData);

    /**
     * onUpdate
     * @param rowData
     */
    void onUpdate(CanalEntry.Header header,CanalEntry.RowData rowData);

    /**
     * onDelete
     * @param rowData
     */
    void onDelete(CanalEntry.Header header,CanalEntry.RowData rowData);
}
