package com.schbrain.canal.client.core;

import com.alibaba.otter.canal.client.CanalConnector;
import com.schbrain.canal.client.annotation.CanalEventListener;
import com.schbrain.canal.client.annotation.ListenPoint;
import com.schbrain.canal.client.annotation.TableFilter;
import com.schbrain.canal.client.conf.CanalClientConfig;
import com.schbrain.canal.client.conf.SchbrainCanalConfig;
import com.schbrain.canal.client.event.CanalEvent;
import com.schbrain.canal.client.transfer.TransponderFactory;
import com.schbrain.canal.client.utils.BeanUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.annotation.AnnotationUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@Slf4j
public class SimpleCanalClient extends AbstractCanalClient {
    /**
     * executor
     */
    private ThreadPoolExecutor executor;

    private final List<CanalEvent> listeners = new ArrayList<>();

    private final List<ListenerPoint> annoListeners = new ArrayList<>();

    public SimpleCanalClient(SchbrainCanalConfig canalConfig, TransponderFactory factory) {
        super(canalConfig,factory);
        executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<>(), Executors.defaultThreadFactory());
        initListeners();
    }

    private void initListeners() {
        log.info("{}: initializing the listeners....", Thread.currentThread().getName());
        List<CanalEvent> list = BeanUtil.getBeansOfType(CanalEvent.class);
        if(list!=null && list.size() > 0){
            for (CanalEvent canalEvent : list) {
                TableFilter table = canalEvent.getClass().getAnnotation(TableFilter.class);
                if(table!=null){
                    System.out.println(table.schame());
                    System.out.println(table.table());
                }
            }
            listeners.addAll(list);
        }
        Map<String, Object> listenerMap = BeanUtil.getBeansWithAnnotation(CanalEventListener.class);
        if (listenerMap != null) {
            for (Object target : listenerMap.values()) {
                Method[] methods = target.getClass().getDeclaredMethods();
                if (methods != null && methods.length > 0) {
                    for (Method method : methods) {
                        ListenPoint l = AnnotationUtils.findAnnotation(method, ListenPoint.class);
                        if (l != null) {
                            annoListeners.add(new ListenerPoint(target, method, l));
                        }
                    }
                }
            }
        }
        log.info("{}: initializing the listeners end.", Thread.currentThread().getName());
        if (log.isWarnEnabled() && listeners.isEmpty() && annoListeners.isEmpty()) {
            log.warn("{}: No listener found in context! ", Thread.currentThread().getName());
        }
    }

    @Override
    protected void process(CanalConnector connector, Map.Entry<String, CanalClientConfig> config) {
        executor.submit(factory.newTransponder(connector, config, listeners, annoListeners));
        //factory.newTransponder(connector, config, listeners, annoListeners).run();
    }

    @Override
    public void stop() {
        super.stop();
        executor.shutdown();
    }
}
