package com.schbrain.canal.client.core;

import com.alibaba.otter.canal.client.CanalConnector;
import com.alibaba.otter.canal.client.CanalConnectors;
import com.alibaba.otter.canal.client.impl.ClusterCanalConnector;
import com.alibaba.otter.canal.client.impl.ClusterNodeAccessStrategy;
import com.alibaba.otter.canal.common.zookeeper.ZkClientx;
import com.schbrain.canal.client.conf.CanalClientConfig;
import com.schbrain.canal.client.exception.CanalClientException;
import org.apache.commons.lang.StringUtils;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;


public class ConnectionFactory {

    /**
     * 创建连接
     * @param config
     * @param destination
     * @return
     */
    public static CanalConnector create(CanalClientConfig config, String destination){
        if(StringUtils.isNotBlank(config.getAddresses())){
            List<InetSocketAddress> inetSocketAddressList=new ArrayList<>();
            String[] hosts=config.getAddresses().split(",");
            for (String hostInfo: hosts) {
                String[] hostAndPort= hostInfo.split(":");
                inetSocketAddressList.add(new InetSocketAddress(hostAndPort[0], Integer.valueOf(hostAndPort[1])));
            }
            return CanalConnectors.newClusterConnector(inetSocketAddressList,destination, config.getUsername(),config.getPassword());
        }else if(StringUtils.isNotBlank(config.getZkHosts())){
            return newClusterConnector(config.getZkHosts(),destination, config.getUsername(), config.getPassword());
        }else{
            new CanalClientException("zkHosts and addresses cannot all empty");
            return null;
        }
    }

    /**
     * 创建带cluster模式的客户端链接，自动完成failover切换，服务器列表自动扫描
     *
     * @param zkServers
     * @param destination
     * @param username
     * @param password
     * @return
     */
    public static CanalConnector newClusterConnector(String zkServers, String destination, String username, String password) {
        ClusterCanalConnector canalConnector = new ClusterCanalConnector(username, password, destination, new ClusterNodeAccessStrategy(destination, ZkClientx.getZkClient(zkServers)));
        canalConnector.setSoTimeout(60 * 1000);
        canalConnector.setIdleTimeout(60 * 60 * 1000);
        return canalConnector;
    }

}
