package com.schbrain.canal.client.core;

import com.alibaba.otter.canal.client.CanalConnector;
import com.schbrain.canal.client.conf.CanalClientConfig;
import com.schbrain.canal.client.conf.SchbrainCanalConfig;
import com.schbrain.canal.client.exception.CanalClientException;
import com.schbrain.canal.client.transfer.TransponderFactory;
import org.apache.commons.lang3.StringUtils;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractCanalClient implements CanalClient {
    /**
     * running flag
     */
    private volatile boolean running;

    /**
     * customer config
     */
    private SchbrainCanalConfig canalConfig;

    /**
     * TransponderFactory
     */
    protected final TransponderFactory factory;


    AbstractCanalClient(SchbrainCanalConfig canalConfig,TransponderFactory factory) {
        Objects.requireNonNull(canalConfig, "canalConfig can not be null!");
        Objects.requireNonNull(canalConfig, "transponderFactory can not be null!");
        this.canalConfig = canalConfig;
        this.factory = factory;
    }

    @Override
    public void start() {
        Map<String, CanalClientConfig> instanceMap = getConfig();
        for (Map.Entry<String,CanalClientConfig> instanceEntry : instanceMap.entrySet()) {
            CanalConnector connector = processInstanceEntry(instanceEntry);
            process(connector, instanceEntry);
        }

    }

    /**
     * To initialize the canal connector
     * @param connector CanalConnector
     * @param config config
     */
    protected abstract void process(CanalConnector connector,Map.Entry<String,CanalClientConfig> config);

    /**
     * 连接
     * @param instanceEntry
     * @return
     */
    private CanalConnector processInstanceEntry(Map.Entry<String,CanalClientConfig> instanceEntry) {
        CanalClientConfig instance = instanceEntry.getValue();
        String destination = instanceEntry.getKey();
        CanalConnector connector = ConnectionFactory.create(instance,destination);
        connector.connect();
        if (!StringUtils.isEmpty(instance.getSubscribe())) {
            connector.subscribe(instance.getSubscribe());
        } else {
            connector.subscribe();
        }
        connector.rollback();
        return connector;
    }

    protected Map<String,CanalClientConfig> getConfig() {
        SchbrainCanalConfig config = canalConfig;
        Map<String,CanalClientConfig> instanceMap;
        if (config != null && (instanceMap = config.getInstances()) != null && !instanceMap.isEmpty()) {
            return config.getInstances();
        } else {
            throw new CanalClientException("can not get the configuration of canal client!");
        }
    }

    @Override
    public void stop() {
        setRunning(false);
    }

    @Override
    public boolean isRunning() {
        return running;
    }

    private void setRunning(boolean running) {
        this.running = running;
    }
}
