package com.schbrain.canal.client.conf;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Canal配置
 * @author zhuyf
 * @date 2022/6/16
 */
@Component
@ConfigurationProperties(prefix = "canal.client")
public class SchbrainCanalConfig {

    /**
     * instance config
     */
    private Map<String, CanalClientConfig> instances = new LinkedHashMap<>();

    /**
     * 获取实例列表
     * @return
     */
    public Map<String, CanalClientConfig> getInstances() {
        return instances;
    }

    /**
     * 设置实例列表
     * @param instances
     */
    public void setInstances(Map<String, CanalClientConfig> instances) {
        this.instances = instances;
    }
}
