package com.schbrain.canal.client.conf;

import com.schbrain.canal.client.core.CanalClient;
import com.schbrain.canal.client.core.SimpleCanalClient;
import com.schbrain.canal.client.transfer.MessageTransponders;
import com.schbrain.canal.client.transfer.TransponderFactory;
import com.schbrain.canal.client.utils.BeanUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;

/**
 * 启动配置类
 *
 * @author zhuyf
 * @date 2022/6/16
 */
@Slf4j
public class CanalClientConfiguration {

    @Autowired
    private SchbrainCanalConfig schbrainCanalConfig;

    @Bean
    @Order(Ordered.HIGHEST_PRECEDENCE)
    public BeanUtil beanUtil() {
        return new BeanUtil();
    }

    @Bean
    private CanalClient canalClient() {
        log.info("starting canal client....");
        TransponderFactory factory = MessageTransponders.defaultMessageTransponder();
        CanalClient client = new SimpleCanalClient(schbrainCanalConfig,factory);
        client.start();
        return client;
    }
}
